/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTException;
import java.awt.Color;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;

public class Functions {
    private static final int CRYSTAL_RADIUS = 10;
    public static String LEFT = "Left: ";
    public static String RIGHT = "Right: ";
    public static String TOP = "Top: ";
    public static String BOTTOM = "Bottom: ";
    public static String FBUTTONWIDTH = "First Button Width: ";
    public static String BUTTONWIDTH = "Button Width: ";
    public static String BUTTONHEIGHT = "Button Height: ";
    public static String TIMERWIDTH = "Timer Width: ";
    public static String TIMERHEIGHT = "Timer Height: ";
    public static String SETUPFILE = "setup.txt";
    public static int UPLEFT = 0;
    public static int UPRIGHT = 1;
    public static int BOTLEFT = 2;
    public static int BOTRIGHT = 3;
    public static int CENTER = 4;
    public static int OFFSET = 5;
    public static int OFFSETB = 6;
    public static int BUTTON = 7;
    public static int ANVIL = 8;
    public static int NONE = 9;
    public static int WINONLY = 10;
    public static int DEFAULT = NONE;
    public static int NORTH = 0;
    public static int NORTHEAST = 1;
    public static int EAST = 2;
    public static int SOUTHEAST = 3;
    public static int SOUTH = 4;
    public static int SOUTHWEST = 5;
    public static int WEST = 6;
    public static int NORTHWEST = 7;
    public static int ALLDIR = 8;
    private static float anvilSegWidth = 23.6f;
    private static float anvilSegHeight = 23.4f;
    private int left;
    private int right;
    private int top;
    private int bottom;
    private int[] center;
    private int firstButtonWidth;
    private int buttonWidth;
    private int buttonHeight;
    private int timerWidth;
    private int timerHeight;
    private int[] anvil;
    private int xOffset;
    private int yOffset;
    private int xOffsetB;
    private int yOffsetB;
    private int[] clear;
    private int Width;
    private int Height;
    private int NumberOfWindows;
    private int NumberOfCols;
    private int BWidth = 0;
    private int BHeight = 0;
    private int BNumberOfWindows = 0;
    private int BNumberOfCols = 0;
    private Robot robot;
    private int delayAdjust = 100;
    private int openCount = 0;
    private int openFail = 0;
    private int minCount = 40;

    public Functions(int l, int u, int InputWidth, int InputHeight, int InputNOW, int InputNOC) {
        this.initFunctions(l, u, InputWidth, InputHeight, InputNOW, InputNOC, 0, 0, 0, 0, 0, 0);
    }

    public Functions(int l, int u, int InputWidth, int InputHeight, int InputNOW, int InputNOC, int l2, int u2, int InputWidth2, int InputHeight2, int InputNOW2, int InputNOC2) {
        this.initFunctions(l, u, InputWidth, InputHeight, InputNOW, InputNOC, l2, u2, InputWidth2, InputHeight2, InputNOW2, InputNOC2);
    }

    public Functions(int InputWidth, int InputHeight, int InputNOW, int InputNOC) {
        this.initFunctions(0, 0, InputWidth, InputHeight, InputNOW, InputNOC, 0, 0, 0, 0, 0, 0);
    }

    public Functions() {
        this.initFunctions(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
    }

    private void initFunctions(int offL, int offU, int InputWidth, int InputHeight, int InputNOW, int InputNOC, int l2, int u2, int InputWidth2, int InputHeight2, int InputNOW2, int InputNOC2) {
        Object r = null;
        String filename = SETUPFILE;
        this.xOffset = offL;
        this.yOffset = offU;
        this.Width = InputWidth;
        this.Height = InputHeight;
        this.NumberOfWindows = InputNOW;
        this.NumberOfCols = InputNOC;
        this.xOffsetB = l2;
        this.yOffsetB = u2;
        this.BWidth = InputWidth2;
        this.BHeight = InputHeight2;
        this.BNumberOfWindows = InputNOW2;
        this.BNumberOfCols = InputNOC2;
        try {
            this.robot = new Robot();
        }
        catch (AWTException awte) {
            System.out.println("The Robot was not initialized " + awte + "\n");
        }
        this.left = 0;
        this.right = 0;
        this.top = 0;
        this.bottom = 0;
        this.firstButtonWidth = 0;
        this.buttonWidth = 64;
        this.buttonHeight = 100;
        this.timerWidth = 0;
        this.timerHeight = 0;
    }

    public void PressButton(int[] xy) {
        this.PressButton(DEFAULT, xy, 0, 10);
    }

    public void PressButton(int loc, int[] xy) {
        this.PressButton(loc, xy, 0, 10);
    }

    public void PressButton(int[] xy, int window) {
        this.PressButton(DEFAULT, xy, window, 10);
    }

    public void PressButton(int[] xy, int window, int delay) {
        this.PressButton(DEFAULT, xy, window, delay);
    }

    public void PressButton(int loc, int[] xy, int window) {
        this.PressButton(loc, xy, window, 10);
    }

    public void PressButton(int loc, int[] xy, int window, int delay) {
        this.PressButtonDelay(this.ConvertCoords(loc, xy, window), delay);
    }

    public void SetClear(int[] xy) {
        if (xy.length == 2) {
            this.clear = new int[2];
            this.clear[0] = xy[0];
            this.clear[1] = xy[1];
        }
    }

    public void SetAnvil(int[] xy) {
        this.anvil = new int[2];
        int i = 0;
        while (i < 2) {
            this.anvil[i] = i < xy.length ? xy[i] : 0;
            ++i;
        }
    }

    int[] ConvertCoords(int loc, int[] xy, int window) {
        int[] newCoords = new int[2];
        if (loc == UPLEFT) {
            newCoords[0] = xy[0] + this.Width * (window % this.NumberOfCols) + this.left;
            newCoords[1] = xy[1] + this.Height * (window / this.NumberOfCols) + this.top;
        } else if (loc == UPRIGHT) {
            newCoords[0] = xy[0] + this.Width * (window % this.NumberOfCols) + this.right;
            newCoords[1] = xy[1] + this.Height * (window / this.NumberOfCols) + this.top;
        } else if (loc == BOTLEFT) {
            newCoords[0] = xy[0] + this.Width * (window % this.NumberOfCols) + this.left;
            newCoords[1] = xy[1] + this.Height * (window / this.NumberOfCols) + this.bottom;
        } else if (loc == BOTRIGHT) {
            newCoords[0] = xy[0] + this.Width * (window % this.NumberOfCols) + this.right;
            newCoords[1] = xy[1] + this.Height * (window / this.NumberOfCols) + this.bottom;
        } else if (loc == CENTER) {
            newCoords[0] = xy[0] + this.Width * (window % this.NumberOfCols) + this.center[0];
            newCoords[1] = xy[1] + this.Height * (window / this.NumberOfCols) + this.center[1];
        } else if (loc == OFFSET) {
            newCoords[0] = xy[0] + this.Width * (window % this.NumberOfCols) + this.xOffset;
            newCoords[1] = xy[1] + this.Height * (window / this.NumberOfCols) + this.yOffset;
        } else if (loc == OFFSETB) {
            newCoords[0] = xy[0] + this.BWidth * (window % this.BNumberOfCols) + this.xOffsetB;
            newCoords[1] = xy[1] + this.BHeight * (window / this.BNumberOfCols) + this.yOffsetB;
        } else if (loc == BUTTON) {
            newCoords[0] = xy[0] + this.left + this.firstButtonWidth + this.buttonWidth * window;
            newCoords[1] = xy[1] + this.top;
        } else if (loc == ANVIL) {
            newCoords[0] = Math.round((float)xy[0] * anvilSegWidth) + this.anvil[0] + this.left;
            newCoords[1] = Math.round((float)xy[1] * anvilSegHeight - (float)(xy[0] % 2) * anvilSegHeight / 2.0f) + this.anvil[1];
        } else if (loc == NONE) {
            newCoords[0] = xy[0];
            newCoords[1] = xy[1];
        } else if (this.NumberOfCols != 0) {
            newCoords[0] = xy[0] + this.Width * (window % this.NumberOfCols);
            newCoords[1] = xy[1] + this.Height * (window / this.NumberOfCols);
        } else {
            newCoords[0] = xy[0];
            newCoords[1] = xy[1];
        }
        return newCoords;
    }

    private void PressButtonDelay(int[] xy, int delay) {
        this.robot.delay(delay);
        this.robot.mouseRelease(20);
        this.robot.mouseMove(xy[0], xy[1]);
        this.robot.delay(delay);
        this.robot.mousePress(4);
        this.robot.delay(5);
        this.robot.mouseRelease(4);
    }

    public void StopWalking() {
        this.robot.keyRelease(38);
        this.robot.keyRelease(40);
        this.robot.keyRelease(37);
        this.robot.keyRelease(39);
    }

    public void StopWalking(int d) {
        if (d == NORTH) {
            this.robot.keyRelease(38);
        } else if (d == SOUTH) {
            this.robot.keyRelease(40);
        } else if (d == WEST) {
            this.robot.keyRelease(37);
        } else if (d == EAST) {
            this.robot.keyRelease(39);
        } else if (d == ALLDIR) {
            this.robot.keyRelease(38);
            this.robot.keyRelease(40);
            this.robot.keyRelease(37);
            this.robot.keyRelease(39);
        }
    }

    public void Walk(int d) {
        if (d == NORTH || d == NORTHEAST || d == NORTHWEST) {
            this.robot.keyPress(38);
        }
        if (d == SOUTH || d == SOUTHEAST || d == SOUTHWEST) {
            this.robot.keyPress(40);
        }
        if (d == EAST || d == SOUTHEAST || d == NORTHEAST) {
            this.robot.keyPress(39);
        }
        if (d == WEST || d == SOUTHWEST || d == NORTHWEST) {
            this.robot.keyPress(37);
        }
    }

    public void Click() {
        this.robot.mouseRelease(4);
        this.robot.mouseRelease(16);
        this.robot.mousePress(4);
        this.robot.mouseRelease(4);
    }

    public void Drag(int startLoc, int[] startXY, int startWindow, int endLoc, int[] endXY, int endWindow) {
        int[] sXY = this.ConvertCoords(startLoc, startXY, startWindow);
        int[] eXY = this.ConvertCoords(endLoc, endXY, endWindow);
        this.robot.delay(100);
        this.robot.mouseMove(sXY[0], sXY[1]);
        this.robot.delay(100);
        this.robot.mousePress(4);
        this.robot.delay(100);
        this.robot.mouseMove(eXY[0], eXY[1]);
        this.robot.delay(100);
        this.robot.mouseRelease(4);
        this.robot.delay(100);
    }

    public void Type(int k) {
        this.robot.keyPress(k);
        this.robot.keyRelease(k);
    }

    public void Delay(int d) {
        int factor = 1000;
        int major = d / factor;
        int minor = d % factor;
        int i = 0;
        while (i < major) {
            this.robot.delay(factor);
            ++i;
        }
        this.robot.delay(minor);
    }

    public void Wait() {
        this.robot.waitForIdle();
    }

    public void Click(int button) {
        this.robot.mousePress(button);
        this.robot.mouseRelease(button);
    }

    public void MouseMove(int[] xy) {
        this.MouseMove(DEFAULT, xy, 0);
    }

    public void MouseMove(int loc, int[] xy) {
        this.MouseMove(loc, xy, 0);
    }

    public void MouseMove(int[] xy, int window) {
        this.MouseMove(DEFAULT, xy, window);
    }

    public void MouseMove(int loc, int[] xy, int window) {
        this.ActualMouseMove(this.ConvertCoords(loc, xy, window));
    }

    private void ActualMouseMove(int[] xy) {
        this.robot.mouseMove(xy[0], xy[1]);
    }

    public Color GetCrystalColor(int loc, int x, int y) {
        int[] xy = new int[]{x, y};
        return this.GetCrystalColor(loc, xy);
    }

    public Color GetCrystalColor(int loc, int[] xy) {
        return this.actualGetCrystalColor(this.ConvertCoords(loc, xy, 0));
    }

    public Color GetCrystalColor(int[] xy) {
        return this.actualGetCrystalColor(this.ConvertCoords(DEFAULT, xy, 0));
    }

    public Color GetPixelColor(int loc, int x, int y) {
        int[] xy = new int[]{x, y};
        return this.GetPixelColor(loc, xy);
    }

    public Color GetPixelColor(int[] xy) {
        return this.actualGetPixelColor(this.ConvertCoords(DEFAULT, xy, 0));
    }

    public Color GetPixelColor(int[] xy, int window) {
        return this.actualGetPixelColor(this.ConvertCoords(DEFAULT, xy, window));
    }

    public Color GetPixelColor(int loc, int[] xy) {
        return this.actualGetPixelColor(this.ConvertCoords(loc, xy, 0));
    }

    public Color GetPixelColor(int loc, int[] xy, int window) {
        return this.actualGetPixelColor(this.ConvertCoords(loc, xy, window));
    }

    private Color actualGetCrystalColor(int[] xy) {
        int[] tmp = new int[]{xy[0] - 10, xy[1] - 10};
        BufferedImage im = this.ScreenCap(tmp, 20, 20);
        int[] rgbArray = im.getRGB(0, 0, im.getWidth(), im.getHeight(), null, 0, im.getWidth());
        int r = 0;
        int g = 0;
        int b = 0;
        int num = 0;
        int[] nArray = rgbArray;
        int n = rgbArray.length;
        int n2 = 0;
        while (n2 < n) {
            int rgb = nArray[n2];
            Color c = new Color(rgb);
            r += c.getRed();
            g += c.getGreen();
            b += c.getBlue();
            ++num;
            ++n2;
        }
        return new Color(r / num, g / num, b / num);
    }

    private Color actualGetPixelColor(int[] xy) {
        return this.robot.getPixelColor(xy[0], xy[1]);
    }

    public Color GetPixelColor(int[] xy, BufferedImage bi) {
        return this.GetPixelColor(xy, 0, bi);
    }

    public Color GetPixelColor(int[] xy, int window, BufferedImage bi) {
        int[] tmp = this.ConvertCoords(WINONLY, xy, window);
        return new Color(bi.getRGB(tmp[0], tmp[1]));
    }

    public int[] GetMouseLocation() {
        return this.GetMouseLocation(DEFAULT, 0);
    }

    public int[] GetMouseLocation(int loc) {
        return this.GetMouseLocation(loc, 0);
    }

    public int[] GetMouseLocation(int loc, int window) {
        int[] xy = new int[]{MouseInfo.getPointerInfo().getLocation().x, MouseInfo.getPointerInfo().getLocation().y};
        int[] diff = this.ConvertCoords(loc, xy, window);
        diff[0] = diff[0] - xy[0];
        diff[1] = diff[1] - xy[1];
        xy[0] = xy[0] - diff[0];
        xy[1] = xy[1] - diff[1];
        return xy;
    }

    public boolean compareColors(Color a, Color b) {
        return this.compareColors(a, b, 15);
    }

    public boolean compareColors(Color a, Color b, int maxDif) {
        int dif = 0;
        dif += Math.abs(a.getRed() - b.getRed());
        dif += Math.abs(a.getGreen() - b.getGreen());
        return (dif += Math.abs(a.getBlue() - b.getBlue())) < maxDif;
    }

    public boolean compareColors(Color[] a, Color[] b) {
        return this.compareColors(a, b, 15);
    }

    public boolean compareColors(Color[] a, Color[] b, int maxDif) {
        int i = 0;
        while (i < a.length) {
            if (!this.compareColors(a[i], b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean OpenWindow(int[] xy) {
        return this.OpenWindow(DEFAULT, xy, 0, true);
    }

    public boolean OpenWindow(int[] xy, int window) {
        return this.OpenWindow(DEFAULT, xy, window, true);
    }

    public boolean OpenWindow(int loc, int[] xy) {
        return this.OpenWindow(loc, xy, 0, true);
    }

    public boolean OpenWindow(int[] xy, boolean canClear) {
        return this.OpenWindow(DEFAULT, xy, 0, canClear);
    }

    public boolean OpenWindow(int[] xy, int window, boolean canClear) {
        return this.OpenWindow(DEFAULT, xy, window, canClear);
    }

    public boolean OpenWindow(int loc, int[] xy, boolean canClear) {
        return this.OpenWindow(loc, xy, 0, canClear);
    }

    public boolean OpenWindow(int loc, int[] xy, int window) {
        return this.OpenWindow(loc, xy, window, true);
    }

    public boolean OpenWindow(int loc, int[] xy, int window, boolean canClear) {
        int[] windowCheck = new int[]{xy[0] + 1, xy[1]};
        int failures = 0;
        int maxFailures = 6;
        int wait = 0;
        int maxWait = 10;
        boolean loop = true;
        boolean first = true;
        int[] jitter = new int[]{this.clear[0] - 1, this.clear[1]};
        while (loop) {
            if (wait < maxWait && !first) {
                ++wait;
                this.Delay(50);
            } else if (failures > maxFailures) {
                failures = 0;
                if (!canClear) {
                    return false;
                }
                if (this.openCount < this.minCount) {
                    this.delayAdjust += 10;
                }
                this.Delay(10000);
            } else {
                wait = 0;
                ++failures;
                if (!first) {
                    ++this.openFail;
                }
                ++this.openCount;
                int[] mouse = this.GetMouseLocation();
                if (canClear) {
                    this.PressButton(jitter);
                    this.Delay(this.delayAdjust);
                    this.PressButton(this.clear);
                }
                this.PressButton(loc, xy, window, this.delayAdjust);
                this.MouseMove(mouse);
            }
            first = false;
            if (this.IsWindowOpen(loc, xy, window)) {
                return true;
            }
            if (this.openCount < this.minCount) continue;
            if (this.openFail * 10 / this.openCount >= 2) {
                this.delayAdjust += 10;
                this.openFail = 0;
                this.openCount = 0;
                continue;
            }
            if (this.openFail * 100 / this.openCount != 0 || this.delayAdjust <= 10) continue;
            this.delayAdjust -= 10;
            this.openFail = 0;
            this.openCount = 0;
        }
        return false;
    }

    public boolean IsWindowOpen(int[] xy) {
        return this.IsWindowOpen(DEFAULT, xy, 0);
    }

    public boolean IsWindowOpen(int[] xy, int window) {
        return this.IsWindowOpen(DEFAULT, xy, window);
    }

    public boolean IsWindowOpen(int loc, int[] xy) {
        return this.IsWindowOpen(loc, xy, 0);
    }

    public boolean IsWindowOpen(int loc, int[] xy, int window) {
        Color color = new Color(112, 79, 46);
        int[] check = new int[]{xy[0] + 1, xy[1]};
        Color color2 = new Color(148, 108, 70);
        int[] check2 = new int[]{xy[0] + 2, xy[1]};
        return this.compareColors(color, this.GetPixelColor(loc, check, window)) && this.compareColors(color2, this.GetPixelColor(loc, check2, window));
    }

    public BufferedImage ScreenCap(int[] xy, int width, int height) {
        return this.ScreenCap(DEFAULT, xy, 0, width, height);
    }

    public BufferedImage ScreenCap(int loc, int[] xy, int width, int height) {
        return this.ScreenCap(loc, xy, 0, width, height);
    }

    public BufferedImage ScreenCap(int[] xy, int window, int width, int height) {
        return this.ScreenCap(DEFAULT, xy, window, width, height);
    }

    public BufferedImage ScreenCap(int loc, int[] xy, int window, int width, int height) {
        int[] tmp = this.ConvertCoords(loc, xy, window);
        return this.robot.createScreenCapture(new Rectangle(tmp[0], tmp[1], width, height));
    }
}

