/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class MacrosPane
extends JPanel
implements ActionListener {
    protected static JMenuBar menuBar;
    protected static JFrame frame;
    private static String[] miningNames;
    private JMenu menu;
    private JMenu menuMining;

    static {
        miningNames = new String[]{"Iron", "Copper", "Tin", "Lead", "Antimony", "Aluminum", "Silver", "Zinc", "Titanium", "Magnesium", "Tungsten", "Lithium", "Platinum", "Strontium"};
    }

    public MacrosPane() {
        menuBar = new JMenuBar();
        this.menuMining = new JMenu("Mining");
        this.menuMining.setMnemonic(77);
        menuBar.add(this.menuMining);
        int i = 0;
        while (i < miningNames.length) {
            this.addMenuItem(miningNames[i], this.menuMining);
            ++i;
        }
        frame.setJMenuBar(menuBar);
        JLabel label = new JLabel("Select a macro from the \"Mining\" menu.\n");
        label.setHorizontalAlignment(2);
        this.add(label);
    }

    private void addMenuItem(String s, JMenu menu) {
        JMenuItem menuItem = new JMenuItem(s);
        menuItem.setActionCommand(s);
        menuItem.addActionListener(this);
        menu.add(menuItem);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Macro macro = (Macro)Class.forName(e.getActionCommand()).newInstance();
            new Thread(macro).start();
        }
        catch (Exception exp) {
            System.out.println("Failed to start a new thread: " + exp.toString());
        }
    }

    private static void createGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        frame = new JFrame("ATITD Macros");
        frame.setDefaultCloseOperation(3);
        MacrosPane mainPain = new MacrosPane();
        mainPain.setOpaque(true);
        frame.setContentPane(mainPain);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MacrosPane.createGUI();
            }
        });
    }
}

