/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;

public class Mining
extends Macro {
    private State currentState = State.START;
    private boolean input = true;
    private boolean nonInput = true;
    private int count = 0;
    private static String[] words = new String[]{"first", "second", "third", "fourth", "fifth", "sixth", "seventh"};
    public static int NUMCRYSTALS = words.length;
    private int maxCount = words.length;
    private AlgMine alg;
    private Functions functions;
    private String[] labels = new String[3];
    private int level = 0;
    private int stop;
    private int[][] coords = new int[this.maxCount][];
    private Color[] colors = new Color[this.maxCount];
    private Color[] oldColors = new Color[this.maxCount];
    private int[] popUpOkButton = new int[]{-8, 98};
    private Color popUpOkColor = new Color(0, 0, 0);
    private StatWatcher stat;
    private boolean start = true;
    private boolean clearDef = false;
    private boolean okDef = false;
    private boolean crystalStart = false;
    private boolean extraInput = false;

    public Mining(AlgMine algorithm) {
        this.alg = algorithm;
        this.functions = new Functions();
    }

    @Override
    public void noInput() {
        this.currentState = State.DONE;
        this.run();
    }

    @Override
    public void setArgs(int[] args) {
        if (args.length == 2) {
            if (this.level == 0) {
                this.level = args[0];
            }
            this.stop = args[1];
        }
    }

    public void setLevel(int l) {
        this.level = l;
    }

    @Override
    public void run() {
        this.labels = new String[1];
        switch (this.currentState) {
            case START: {
                this.labels = new String[3];
                this.labels[0] = "Enter your mining level: ";
                this.labels[1] = "How many pulls before stopping (enter a negative number for no stop): ";
                this.labels[2] = "Place your cursor over the ground/sky.";
                int[] defaults = new int[]{5, -1};
                this.currentState = State.GETTING_CLEAR;
                new PromptWindow(this.labels, this, 2, defaults);
                break;
            }
            case GETTING_CLEAR: {
                this.functions.SetClear(this.functions.GetMouseLocation());
                this.currentState = State.GETTING_STAT;
                this.stat = new StatWatcher(this, "Strength or Perception, which ever stat is lower", 250);
                break;
            }
            case GETTING_STAT: {
                this.currentState = State.GETTING_EXTRA;
                if (this.alg.getMoreInput()) break;
            }
            case GETTING_EXTRA: 
            case GETTING_CRYSTALS: {
                if (this.currentState == State.GETTING_CRYSTALS) {
                    this.coords[this.count] = this.functions.GetMouseLocation();
                    ++this.count;
                }
                this.currentState = State.GETTING_CRYSTALS;
                if (this.count < this.maxCount) {
                    this.labels[0] = "Place your cursor over the " + words[this.count] + " crystal and hit \"enter\".";
                    new PromptWindow(this.labels, this);
                    break;
                }
                this.currentState = State.DONE;
            }
            case DONE: {
                this.mine();
            }
        }
    }

    private void mine() {
        int[] history = new int[this.level];
        int place = 0;
        int c = 0;
        int stall = 0;
        int j = 0;
        while (j < this.level) {
            history[j] = 0;
            ++j;
        }
        j = 0;
        while (j < this.maxCount) {
            this.oldColors[j] = new Color(0, 0, 0);
            this.colors[j] = this.functions.GetCrystalColor(this.coords[j]);
            ++j;
        }
        int i = 0;
        while (i < this.stop || this.stop < 0) {
            stall = 0;
            while (this.functions.compareColors(this.colors, this.oldColors)) {
                this.functions.Delay(50);
                this.updateColors();
                if (++stall % 100 == 0) {
                    System.out.println("Stalled waiting for color change.");
                    this.functions.Delay(10000);
                    continue;
                }
                if (stall % 40 != 0 || !this.stat.ready()) continue;
                this.work(c);
            }
            this.updateColors();
            j = 0;
            while (j < this.maxCount) {
                this.oldColors[j] = this.colors[j];
                ++j;
            }
            c = this.alg.choose(this.colors, history, place);
            System.out.println("");
            while (!this.stat.ready()) {
                this.functions.Delay(250);
            }
            this.work(c);
            place = (place + 1) % this.level;
            this.functions.Delay(15000);
            ++i;
        }
    }

    private boolean checkPopUp() {
        return this.functions.compareColors(this.popUpOkColor, this.functions.GetPixelColor(this.popUpOkButton));
    }

    private void closePopUp() {
        int[] mouse = this.functions.GetMouseLocation();
        this.functions.PressButton(this.popUpOkButton, 0);
        this.functions.MouseMove(mouse);
    }

    private void updateColors() {
        int j = 0;
        while (j < this.maxCount) {
            this.colors[j] = this.functions.GetCrystalColor(this.coords[j]);
            ++j;
        }
    }

    private void work(int crystal) {
        int[] loc = new int[2];
        int x = 20;
        int startY = 0;
        int changeY = -8;
        int workDistance = 11;
        Color c = new Color(115, 105, 79);
        loc[0] = this.coords[crystal][0] + x;
        loc[1] = this.coords[crystal][1] + startY;
        this.functions.OpenWindow(this.coords[crystal]);
        int i = 0;
        while (i < 4) {
            if (this.functions.compareColors(c, this.functions.GetPixelColor(loc))) break;
            loc[1] = loc[1] + changeY;
            ++i;
        }
        if (i == 4) {
            System.out.println("Can't find work button!");
            throw new RuntimeException("Can't find work button!");
        }
        loc[1] = loc[1] + workDistance;
        int[] mouse = this.functions.GetMouseLocation();
        this.functions.PressButton(loc);
        this.functions.MouseMove(mouse);
    }

    static enum State {
        START,
        GETTING_CLEAR,
        GETTING_STAT,
        GETTING_EXTRA,
        GETTING_CRYSTALS,
        DONE;

    }
}

