/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PromptWindow
implements ActionListener {
    protected static JFrame frame;
    protected static JButton jbnOk;
    private LinkedList<JTextField> inputs = new LinkedList();
    private int[] args;
    private Macro macro;
    private static String OK;
    private boolean fork = true;

    static {
        OK = "Ok Pressed";
    }

    public PromptWindow(String[] labels, Macro m) {
        this.setUpWindow(labels, m, 0, null);
    }

    public PromptWindow(String[] labels, Macro m, int numArgs) {
        this.setUpWindow(labels, m, numArgs, null);
    }

    public PromptWindow(String[] labels, Macro m, int numArgs, int[] argDefaults) {
        this.setUpWindow(labels, m, numArgs, argDefaults);
    }

    private void setUpWindow(String[] labels, Macro m, int numArgs, int[] argDefaults) {
        this.macro = m;
        this.args = new int[numArgs];
        JFrame.setDefaultLookAndFeelDecorated(true);
        frame = new JFrame("Prompt");
        frame.setDefaultCloseOperation(2);
        JPanel mainPane = new JPanel();
        if (labels != null) {
            int i = 0;
            while (i < labels.length || i < numArgs) {
                if (i < labels.length) {
                    JLabel label = new JLabel(labels[i]);
                    label.setHorizontalAlignment(2);
                    mainPane.add(label);
                }
                if (i < numArgs) {
                    String s = argDefaults != null && i < argDefaults.length ? Integer.toString(argDefaults[i]) : "0";
                    JTextField text = new JTextField(s, 4);
                    this.inputs.add(text);
                    mainPane.add(text);
                }
                ++i;
            }
        }
        jbnOk = new JButton("Ok");
        jbnOk.setMnemonic(79);
        jbnOk.setActionCommand(OK);
        jbnOk.addActionListener(this);
        mainPane.add(jbnOk);
        mainPane.setOpaque(true);
        frame.getRootPane().setDefaultButton(jbnOk);
        frame.setContentPane(mainPane);
        frame.pack();
        frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int numArgs = this.inputs.size();
        int[] args = new int[numArgs];
        if (e.getActionCommand().equals(OK)) {
            int i = 0;
            while (i < numArgs) {
                args[i] = Integer.parseInt(this.inputs.get(i).getText());
                ++i;
            }
            this.macro.setArgs(args);
            frame.dispose();
            if (this.fork) {
                Thread t = new Thread(this.macro);
                t.start();
            } else {
                this.macro.run();
            }
        }
    }
}

