/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;

public class Strontium
extends AlgMine {
    private State state = State.WAITING;
    private int position = 0;
    private int[] sequence = null;

    public Strontium() {
        this.mining = new Mining(this);
    }

    @Override
    public void setArgs(int[] args) {
        switch (this.state) {
            case GETTING_LENGTH: {
                if (args.length != 1 || args[0] <= 0) break;
                System.out.println("Sequence length " + args[0]);
                this.sequence = new int[args[0]];
                break;
            }
            case GETTING_SEQUENCE: {
                if (args.length != this.sequence.length) break;
                int i = 0;
                while (i < args.length) {
                    this.sequence[i] = args[i] > 0 && args[i] <= Mining.NUMCRYSTALS ? args[i] - 1 : -1;
                    ++i;
                }
                break;
            }
        }
    }

    @Override
    public void run() {
        switch (this.state) {
            case WAITING: {
                this.mining.run();
                break;
            }
            case GETTING_LENGTH: {
                if (this.sequence == null) {
                    return;
                }
                String[] labels = new String[]{"Enter the sequence:"};
                this.state = State.GETTING_SEQUENCE;
                new PromptWindow(labels, this, this.sequence.length);
                break;
            }
            case GETTING_SEQUENCE: {
                int[] nArray = this.sequence;
                int n = this.sequence.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    if (i < 0) {
                        System.out.println("Sequence screwed up");
                        throw new RuntimeException("Sequence screwed up");
                    }
                    ++n2;
                }
                this.state = State.DONE;
            }
            case DONE: {
                this.mining.run();
            }
        }
    }

    @Override
    public boolean getMoreInput() {
        String[] labels = new String[]{"Enter the length of the sequence:"};
        this.state = State.GETTING_LENGTH;
        new PromptWindow(labels, this, 1);
        return true;
    }

    @Override
    protected int convert(Color color) {
        return 0;
    }

    @Override
    public int choose(Color[] colors, int[] history, int place) {
        int retval = this.sequence[this.position];
        this.position = (this.position + 1) % this.sequence.length;
        return retval;
    }

    @Override
    protected int oddOneOut(Color[] colors) {
        return 0;
    }

    static enum State {
        WAITING,
        GETTING_LENGTH,
        GETTING_SEQUENCE,
        DONE;

    }
}

