;Author: Qu
;Version: 1.02

#NoEnv
SendMode Input
SetWorkingDir %A_ScriptDir%
SetDefaultMouseSpeed, 0
SetTitleMatchMode, 3        ;Exact window title match
SetMouseDelay, -1
ATITDWindow:="eGenesis Client ahk_class eGenesis Client"

;Offsets from bottom left corner
;
;Add wood -   +36, -25
;Add water -  +85, -25
;Vent low -   +131, -25
;Vent med -   +156, -25
;Vent high -  +181, -25

;TODO:
;recovery on error

DebugMode:=0
Ovens:=0

;Find game window(s)
While (WindowHandle == "" || WindowHandle == 0)
{
  WinWait, %ATITDWindow%
  WinGet, WindowHandle, List, %ATITDWindow%
  If (A_Index > 50)
  {
    MsgBox, Error detecting ATITD Window.
    return
  }
}
If (%WindowHandle% > 1)
{
  MsgBox, Multiple game windows found. Multiple clients not supported.
}
WinGetPos, WinPosX, WinPosY, WindowWidth, WindowHeight, ahk_id %WindowHandle1%

SearchStartX:=0
SearchStartY:=0
OvenFile1:="charcoal_oven.png"
OvenFile2:="charcoal_hearth.png"
While (SearchStartY <= WindowHeight - 150)
{
  WinWaitActive, %ATITDWindow%
  ImageSearch, FoundX, FoundY, SearchStartX, SearchStartY, WindowWidth, WindowHeight - 150, *60 this_is.png
  If (ErrorLevel == 2)
  {
    MsgBox, this_is.png: Error opening file or invalid search parameters.
    return
  }
  If (ErrorLevel == 1)
  {
    break
  }
  ;If we got this far we must've found a window. Let's see if it's a Charcoal Oven or Charcoal Hearth or neither.
  Loop, 2
  {
    CurrentFile:=OvenFile%A_Index%
    ImageSearch, , , FoundX, FoundY, FoundX + 200, FoundY + 30, *60 %CurrentFile%
    If (ErrorLevel == 2)
    {
      MsgBox, %CurrentFile%: Error opening file or invalid search parameters.
      return
    }
    Else If (ErrorLevel == 1)
    {
      continue
    }
    ;ErrorLevel == 0
    Ovens++
    OvenX%Ovens%:=FoundX
    OvenY%Ovens%:=FoundY
    break
  }
  ;Now we find all windows on the same line as the one we found
  SearchStartX2:=FoundX + 1
  SearchStartY2:=FoundY
  While (SearchStartX2 <= WindowWidth)
  {
    ImageSearch, FoundX2, FoundY2, SearchStartX2, SearchStartY2, WindowWidth, SearchStartY2 + 22, *60 this_is.png
    If (ErrorLevel == 2)
    {
      MsgBox, this_is.png: Error opening file or invalid search parameters.
      return
    }
    If (ErrorLevel == 1)
    {
      break
    }
    ;ErrorLevel == 0
    ;If we got this far we must've found a window. Let's see if it's a Charcoal Oven or Charcoal Hearth or neither.
    Loop, 2
    {
      CurrentFile:=OvenFile%A_Index%
      ImageSearch, , , FoundX2, FoundY2, FoundX2 + 200, FoundY2 + 30, *60 %CurrentFile%
      If (ErrorLevel == 2)
      {
        MsgBox, %CurrentFile%: Error opening file or invalid search parameters.
        return
      }
      Else If (ErrorLevel == 1)
      {
        continue
      }
      ;ErrorLevel == 0
      Ovens++
      OvenX%Ovens%:=FoundX2
      OvenY%Ovens%:=FoundY2
      break
    }
    SearchStartX2:=FoundX2 + 1
  }
  SearchStartY:=FoundY + 1
}

While (DebugMode == 1 && A_Index <= Ovens)
{
  ToolTip, %A_Index%, OvenX%A_Index%, OvenY%A_Index%, A_Index
  Temp1:=OvenX%A_Index%
  Temp2:=OvenY%A_Index%
  FileAppend, Oven%A_Index%: %Temp1%`, %Temp2%`n, debug.txt 
}

;At this point we found all the oven and hearth windows. Now let's find the lower left and lower right corners.
While((i:=A_Index) <= Ovens)
{
  ImageSearch, FoundX, , OvenX%i%, OvenY%i%, WindowWidth, OvenY%i% + 7, *60 upper_right_8x8.png
  If (ErrorLevel == 2)
  {
    MsgBox, upper_right_8x8.png: Error opening file or invalid search parameters.
    return
  }
  If (ErrorLevel == 1)
  {
    ;ToDo: Could try to find the lower right corner here instead of aborting.
    MsgBox, Could not find the upper right corner of oven %i%. Make sure no windows overlap.
    return
  }
  ;ErrorLevel == 0
  OvenWidth%i%:=FoundX - OvenX%i% + 8
  OvenEndX%i%:=FoundX + 8
  
  ImageSearch, , FoundY, OvenX%i%, OvenY%i%, OvenX%i% + 15, WindowHeight, *60 lower_left_16x16.png
  If (ErrorLevel == 2)
  {
    MsgBox, lower_left_16x16.png: Error opening file or invalid search parameters.
    return
  }
  If (ErrorLevel == 1)
  {
    ;ToDo: Could try to find the lower right corner here instead of aborting.
    MsgBox, Could not find the lower left corner of oven %i%. Make sure no windows overlap.
    return
  }
  ;ErrorLevel == 0
  OvenHeight%i%:=FoundY - OvenY%i% + 16
  OvenEndY%i%:=FoundY + 16
}

;Now that we know the dimension of the windows, let's find the Begin buttons.
While((i:=A_Index) <= Ovens)
{
  ImageSearch, FoundX, FoundY, OvenX%i%, OvenY%i%, OvenEndX%i%, OvenEndY%i%, *70 begin.png
  If (ErrorLevel == 2)
  {
    MsgBox, begin.png: Error opening file or invalid search parameters.
    return
  }
  If (ErrorLevel == 1)
  {
    ;ToDo: If button is being moused over
    MsgBox, Could not find the Begin button for oven %i%.
    return
  }
  ;ErrorLevel == 0
  OvenBeginX%i%:=FoundX
  OvenBeginY%i%:=FoundY
}

If (Ovens != "" && Ovens > 0)
{
  MsgBox, Found %Ovens% ovens/hearths. Hit Ctrl+Alt+Shift+`` (that's the tilde key) to begin.
}
else
{
  MsgBox, No ovens or hearths found!
  return
}

#IfWinActive, eGenesis Client ahk_class eGenesis Client

;Clicks the Begin buttons.
^+!`::
;Do some sanity checks first before starting.
If (Ovens == "" || Ovens <= 0)
{
  MsgBox, No ovens found. Aborting.
  return
}
While((i:=A_Index) <= Ovens)
{
  If (OvenX%i% == "" || OvenY%i% == "" || OvenBeginX%i% == "" || OvenBeginY%i% == "" || OvenEndX%i% == "" || OvenEndY%i% == "")
  {
    MsgBox, Oven %i%: Error found with oven parameters.
    return
  }
}

While((i:=A_Index) <= Ovens)
{
  KeyWait, LButton
  KeyWait, RButton
  MouseClick, Left, OvenBeginX%i%, OvenBeginY%i%
  MouseMove, MouseX, MouseY
}
return

;add wood
^a::
While((i:=A_Index) <= Ovens)
{
  KeyWait, LButton
  KeyWait, RButton
  MouseGetPos, MouseX, MouseY
  MouseClick, Left, OvenX%i% + 36, OvenEndY%i% - 25
  MouseMove, MouseX, MouseY
}
return

;adds water
^w::
While((i:=A_Index) <= Ovens)
{
  KeyWait, LButton
  KeyWait, RButton
  MouseGetPos, MouseX, MouseY
  MouseClick, Left, OvenX%i% + 85, OvenEndY%i% - 25
  MouseMove, MouseX, MouseY
}
return

;Sets vent to low
^1::
While((i:=A_Index) <= Ovens)
{
  KeyWait, LButton
  KeyWait, RButton
  MouseGetPos, MouseX, MouseY
  MouseClick, Left, OvenX%i% + 131, OvenEndY%i% - 25
  MouseMove, MouseX, MouseY
}
return

;Sets vent to medium
^2::
While((i:=A_Index) <= Ovens)
{
  KeyWait, LButton
  KeyWait, RButton
  MouseGetPos, MouseX, MouseY
  MouseClick, Left, OvenX%i% + 156, OvenEndY%i% - 25
  MouseMove, MouseX, MouseY
}
return

;Sets vent to high
^3::
While((i:=A_Index) <= Ovens)
{
  KeyWait, LButton
  KeyWait, RButton
  MouseGetPos, MouseX, MouseY
  MouseClick, Left, OvenX%i% + 181, OvenEndY%i% - 25
  MouseMove, MouseX, MouseY
}
return

#IfWinActive
;Script macros here
^+!r::Reload
^+!e::Edit